<?php

namespace Mtc\Auction\Http\Controllers;

use Illuminate\Support\Facades\App;
use Mtc\Auction\AuctionMember;
use Mtc\Core\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Event;
use Mtc\Auction\Lot\Storage;
use Mtc\Auction\Bid;
use Mtc\Auction\Events\BidUpdate;
use Mtc\Auction\Lot;
use Mtc\Auction\Lot\Status;
use Mtc\Auction\Watchlist;
use Mtc\Auction\Http\Response\Lotlist;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Shop\Item;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Members\HasMembersNavigation;

class StorageController extends Controller
{
    use HasMembersNavigation;
    /**
     * Members' Storage Lots
     *
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function index()
    {
        $this->member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;

        if (!$this->member->exists) {
            return redirect()->to('/members/login');
        }

        $this->member = AuctionMember::mutateMemberObject($this->member);

        $page_meta = [
            'page_title' => 'My Storage',
        ];

        app('twig')->addGlobal("is_members_area", true);

        return template('Auction/members/my-storage.twig', [
            'page_meta' => $page_meta,
            'sections' => $this->sections()
        ]);
    }

    /**
     * List lots in storage
     *
     * @param Request $request
     *
     * @return \Illuminate\Support\Collection
     */
    public function show(Request $request)
    {
        $this->member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;
        
        $collection = Lot::query()
                         ->whereHas('storageLots', function ($query) {
                             return $query->where('member_id', $this->member->id);
                         })
                         ->get();

        return (new LotList($collection))->handle();
    }

    /**
     * Ship lots
     *
     * @param Request $request
     */
    public function ship(Request $request)
    {
        $this->member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;

        $basket_interface = App::make(BasketRepositoryInterface::class);

        Storage::query()
               ->where('member_id', $this->member->id)
               ->whereIn('lot_id', $request->input('ship_lots'))
               ->get()
               ->each(function ($storage_item) use ($basket_interface) {
                   // Find the item and lot of the storage item
                   //$item = Item::query()->where('epos_code', Storage::PLU)->first();

                   $lot = $storage_item->lot;
                   // lot must exist and it must be a sold lot
                   if (!($lot->id && in_array($lot->status, Status::$winning_statuses))) {
                       return;
                   }

                   if (!$basket_interface->hasItem($storage_item)) {
                       $basket_interface->addItem($storage_item, 1, true, false);
                   }

                   /*$size = Item\Size::query()->firstOrCreate([
                       'item_id' => LOT_PURCHASE_ITEM_ID,
                       'PLU' => $lot->id,
                   ], [
                       'size' => $lot->lot_id . ' - ' . $lot->name,
                       'price' => $lot->getPurchasePrice(),
                       'price_exvat' => $lot->getPurchasePrice(true),
                       'stock' => 1,
                       'weight' => $lot->weight,
                   ]);*/

                   // Add item to basket if it already isn't in it
                   /*$params = [
                       'id' => $item->id,
                       'size' => 'Lot # ' . $lot->lot_id . ' - ' . $lot->name,
                       'size_id' => $size->id,
                       'quantity' => 1,
                       'weight' => $lot->weight,
                       'PLU' => Storage::PLU
                   ];
                   $basket->Add_Item($params);*/
               });

        return redirect()->to('/basket');
    }
}