<?php

namespace Mtc\Auction\Http\Controllers\Auth;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Mtc\Auction\AuctionMemberFields;
use Mtc\Members\Http\Controllers\Auth\RegisterController as SourceRegisterController;
use Mtc\Members\Member;

class RegisterController extends SourceRegisterController
{

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\Http\Response|string
     */
    public function showRegistrationForm(Request $request)
    {
        $this->page_meta['title'] = 'Register | ' . config('app.name');
        $this->page_meta['page_title'] = 'Register';
        
        app('twig')->addGlobal("is_members_area", true);
        
        return template('members/register.twig', [
            'page_meta' => $this->page_meta,
            'redirect' => $request->get('redirect'),
        ]);
    }
    

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return Member|Model
     */
    protected function create(array $data)
    {
        $member =  Member::query()
                     ->create([
                                  'name' => $data['name'],
                                  'email' => $data['email'],
                                  'password' => Hash::make($data['password']),
                              ]);

        $auction_settings  = new AuctionMemberFields();
        $auction_settings->member_id = $member->id;
        $auction_settings->generateUniqueID();
        $auction_settings->save();
        
        return $member;
    }
}