<?php

namespace Mtc\Auction\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Mtc\Auction\Auction;
use Mtc\Core\Http\Controllers\Controller;

class AuctionShopSearchController extends Controller
{

    public function index(Request $request){
        switch($request->input('destination')){
            case 'shop':
                return Redirect::to('/browse/q-' .  urlencode($request->input('search-filter')));
                break;
            case 'auction':
            default:
                if(Auction::currentLiveAuction()){
                    return Redirect::to('/live-auction')->with('search_filter', $request->input('search-filter'));   
                }
                return Redirect::to('/past-auctions/search')->with('search_filter', $request->input('search-filter'));
                break;
        }
    }
}