<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Mtc\Auction\Lot\Storage;
use Mtc\Auction\Lot\StorageLocation;

class LotStorageLocationController extends Controller
{
    public function index(Request $request)
    {
        $storage_locations = StorageLocation::query()
                                            ->get();

        $this->page_meta['title'] = 'Lot Storage Locations';
        
        return template('Auction/admin/storage-locations/index.twig', [
            'page_meta' => $this->page_meta,
            'storage_locations' => $storage_locations,
        ]);
    }
    
    public function create(Request $request){
        $this->page_meta['title'] = 'Create Storage Location';

        return template('Auction/admin/storage-locations/edit.twig', [
            'page_meta' => $this->page_meta,
        ]);
    }
    
    public function edit(Request $request, $storage_location_id){
        $this->page_meta['title'] = 'Edit Storage Location Info';

        $storage_location = StorageLocation::findOrFail($storage_location_id);
        return template('Auction/admin/storage-locations/edit.twig', [
            'storage_location' => $storage_location,
            'page_meta' => $this->page_meta,
        ]);
    }

    public function store(Request $request)
    {
        $storage_location = new StorageLocation();

        $storage_location->fill($request->input());
        $storage_location->save();

        session()->flash('success', 'Storage Lot Updated');
        return redirect()->to('/admin/lots/storage-location/' . $storage_location->id . '/edit');
    }
    
    public function update(Request $request, $storage_location_id)
    {
        $storage_location = StorageLocation::find($storage_location_id);

        $storage_location->name = ($request->input('name'));
        $storage_location->description = ($request->input('description'));
        $storage_location->address = ($request->input('address'));
        $storage_location->save();

        session()->flash('success', 'Storage Lot Updated');
        return redirect()->back();
    }
}