<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Mtc\Auction\Bid\Rule;

class BidIncrementController extends Controller
{
    /**
     * Bid Increment list page
     *
     * @return string
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function index()
    {
        $this->page_meta['title'] = 'Bidding Increments';
        return template('Auction/admin/bids/increments.twig', [
            'rules' => Rule::query()->orderBy('min', 'asc')->get(),
            'page_meta' => $this->page_meta,
        ]);
    }

    /**
     * Process Bid Increment update request
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request)
    {
        $validated = $this->validate($request, [
            'rule' => 'required',
            'rule.*.min' => 'required|numeric',
            'rule.*.max' => 'required|numeric',
            'rule.*.step_size' => 'required|numeric',
        ]);

        foreach ($validated['rule'] as $rule_id => $rule_values) {
            $rule = Rule::query()->find($rule_id);
            $rule->fill($rule_values);
            $rule->save();
        }

        session()->flash('success', 'Bidding Increments Updated');
        return redirect()->to("/admin/bids/increments");
    }
}