<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Auction\Auction;
use Mtc\Auction\AuctionMember;
use Mtc\Auction\Bid;
use Mtc\Auction\Lot;

class BidController extends Controller
{
    public function index(Request $request)
    {
        $per_page = 50;

        if ($request->wantsJson()) {
            $page = $request->get('page') ?? 1;

            $bid_query = Bid::query()
                            ->with([
                                'lot.latestBid',
                                'member',
                            ]);

            if (!empty($request->get('auction_id')) || !empty($request->get('lot_id'))) {
                $bid_query->whereHas('lot', function ($query) use ($request) {
                    if (!empty($request->get('auction_id'))) {
                        $query->where('auction_id', $request->get('auction_id'));
                    }

                    if (!empty($request->get('lot_id'))) {
                        $query->where(config('auction.lots.identifier'), $request->get('lot_id'));
                    }
                });
            }

            if (!empty($request->get('buyer_id'))) {
                $bid_query->where('member_id', $request->get('buyer_id'));
            }

            return [
                'num_results' => $bid_query->count(),
                'data' => $bid_query
                    ->latest()
                    ->orderByDesc('id')
                    ->skip(($page - 1) * $per_page)
                    ->take($per_page)
                    ->get()
                    ->map(function ($bid) {
                        $bid->can_update = $bid->id == $bid->lot->latestBid->id && $bid->max_bid > $bid->bid;
                        return $bid;
                    }),
            ];
        }

        if (!empty($request->get('auction_id'))) {
            $member_ids = Bid::query()
                             ->with([
                                 'lot.latestBid',
                                 'member',
                             ])
                             ->whereHas('lot', function ($query) use ($request) {
                                 if (!empty($request->get('auction_id'))) {
                                     $query->where('auction_id', $request->get('auction_id'));
                                 }
                             })
                             ->groupBy('member_id')
                             ->pluck('member_id');

            $buyer_list = AuctionMember::whereIn('id', $member_ids)
                                ->get()
                                ->keyBy('id')
                                ->map(function ($member) {
                                    return $member->name . ' [ ' . $member->email . ' ]';
                                })
                                ->sort();
        } else {
            $buyer_list = [];
        }

        $this->page_meta['title'] = 'Placed Bids';
        return template('Auction/admin/bids/index.twig', [
            'page_meta' => $this->page_meta,
            'old' => $request,
            'auction_list' => Auction::idNameList(),
            'lot_list' => !empty($request->get('auction_id')) ? Lot::idNameList($request->get('auction_id'), true) : [],
            'buyer_list' => $buyer_list,
            'per_page' => $per_page,
        ]);
    }
}