<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Auction\AuctionMembershipFee;

class AuctionMemberFeesController extends Controller
{
    public function index(Request $request){
        $this->page_meta['title'] = 'Manage Membership Fees';
        $member_fees = AuctionMembershipFee::query()
                           ->latest()
                           ->orderBy('id', 'desc')->get();


        return template('Auction/admin/auctions-member-fees/index.twig', [
            'member_fees' => $member_fees,
            'page_meta' => $this->page_meta,
        ]);

    }

    /**
     * View Auction Create form
     *
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function create()
    {
        $this->page_meta['title'] = 'Create Membership Fee';
        return template('Auction/admin/auctions-member-fees/edit.twig', [
            'member_fee' => new AuctionMembershipFee,
            'page_meta' => $this->page_meta,
        ]);
    }

    /**
     * Process Auction create request
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request)
    {
        $validated = $this->validate($request, [
            'name' => 'required',
            'sku' => 'present',
            'amount' => 'required|numeric',
            'type' => 'required',
        ]);

        $member_fee = new AuctionMembershipFee;
        $member_fee->fill($validated);
        $member_fee->save();

        session()->flash('success', 'Membership Fee Created');
        return redirect()->to("/admin/auction/member-fees/{$member_fee->id}/edit");
    }

    /**
     * View Auction Edit form
     *
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function edit($member_fee_id)
    {
        $this->page_meta['title'] = 'Edit Membership Fees Info';

        $member_fee = AuctionMembershipFee::query()->findOrFail($member_fee_id);

        return template('Auction/admin/auctions-member-fees/edit.twig', [
            'member_fee'               => $member_fee,
            'page_meta'             => $this->page_meta,
        ]);
    }

    /**
     * Process Auction update request
     *
     * @param Request $request
     * @param $auction_id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, $member_fee_id)
    {
        $auction = AuctionMembershipFee::query()->find($member_fee_id);

        $validated = $this->validate($request, [
            'name' => 'required',
            'sku' => 'present',
            'amount' => 'required|numeric',
            'type' => 'required',
        ]);
        $auction->fill($validated);
        $auction->save();

        session()->flash('success', 'Membership Fee Updated');
        return redirect()->to("/admin/auction/member-fees/{$auction->id}/edit");
    }
}