<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Auction\DataImporter;
use Mtc\Auction\Exceptions\DataImporterException;

class AuctionDataImporterController extends Controller
{
    /**
     * View Auction List
     *
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function index(Request $request)
    {
        $page_meta['title'] = 'Auction Data Importer';
        $step               = 1;
        $messages           = [];

        if (!empty(session('message'))) {
            $messages[] = [
                'type'    => 'success',
                'content' => session('message'),
            ];
            session('message');
        }


        return template('DataImporter/admin/index.twig', [
            'page_meta'    => $page_meta,
            'messages'     => $messages,
            'step'         => $step,
            'import_types' => DataImporter::getTypes(),
        ]);
    }

    public function import(Request $request)
    {
        if ($request->input('action') === 'import') {
            try {
                $response = [
                    'status' => 'ok',
                ];

                $file_data = $request->file('import_file');

                if (empty($file_data) && !empty($request->input('import_file'))) {
                    $file_data = $request->input('import_file');
                }

                $data_importer = new DataImporter([
                                                      'application/vnd.ms-excel',
                                                      'text/csv',
                                                      'text/plain',
                                                  ]);

                if ((int)$request->input('step') === 1) {
                    $response = array_merge(
                        $response,
                        $data_importer->preview($request->input('import_type'), $file_data),
                        [
                            'step' => 2,
                        ]
                    );
                } else {
                    $data_importer->import(
                        $request->input('import_type'),
                        $file_data,
                        $request->input('import_parameters')
                    );
                }
            } catch (DataImporterException $exception) {
                $response = [
                    'status'  => 'error',
                    'message' => $exception->getMessage(),
                ];
            }
            
            $returning_json = json_encode($response);
            if($returning_json === false){
                $final_response = json_encode([
                    'status'  => 'error',
                    'message' => 'Contents of the spreadsheet was not valid. Please make sure that only UTF-8 characters are used.',
                ]);
            } else {
                $final_response = $returning_json;
            }
            
            header('Content-Type: application/json');
            exit($final_response);
        }
    }
}