<?php

namespace Mtc\Auction\Filter;

use Illuminate\Support\Facades\DB;
use Mtc\Auction\Bid;
use Mtc\Auction\Lot;

/**
 * Class SortByPrice
 *
 * @package Mtc\Modules\Auction\Classes\Filter
 */
class SortByPrice extends BaseSort
{
    /**
     * @param string $direction
     * @return mixed
     */
    public function handle($direction = 'desc')
    {
        $bid_table = (new Bid)->getTable();
        $lot_table = (new Lot)->getTable();

        $sub_query = DB::table($bid_table)
            ->orderBy('bid', 'desc')
            ->select('bid')
            ->whereRaw("{$lot_table}.id = {$bid_table}.lot_id")
            ->where('deleted_at', null)
            ->limit(1);

        $sub_query = 'coalesce((' . $sub_query->toSql() . '), 0)';
        $sub_query = 'greatest(' . $sub_query . ', coalesce(`auction_lots`.`starting_price`, 0))';

        return $this->query
            ->select("{$lot_table}.*")
            ->selectSub($sub_query, 'bid_value')
            ->orderBy('bid_value', $direction);
    }
}