<?php

/**
 * Clone of Custom Fields for Products. 
 * Old Set up used the exact same classes and made it so that Proucts and Lots had to share
 * In this new set up we cannot have that and so Lots get their own custom fields
 *
 * @version 03/08/23
 * @author Jack Donaldson <jack.donaldson@mtc.co.uk>
 */

namespace Mtc\Auction;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\HigherOrderCollectionProxy;
use Mtc\Taxonomies\Taxonomy;

/**
 * Custom Field Set Field Eloquent model.
 * Defines the model for Custom field assignments to a set
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomFieldSetField extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'auction_custom_fields_sets_fields';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'set_id',
        'custom_field_id',
        'required',
        'lots',
        'variations',
        'filter',
        'order'
    ];

    /**
     * Define relationship to the custom field
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function field()
    {
        return $this->belongsTo(CustomField::class, 'custom_field_id');
    }

    /**
     * Define relationship to the custom field set
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function set()
    {
        return $this->belongsTo(CustomFieldSet::class, 'set_id');
    }

    /**
     * Get the dropdown list options
     *
     * @return array|\Illuminate\Database\Eloquent\HigherOrderBuilderProxy|HigherOrderCollectionProxy|mixed
     */
    public function getDropdownOptions()
    {
        return Taxonomy::query()
            ->findOrNew($this->field->custom_field_list_id)
            ->descendants ?? [];
    }
}
