<?php

/**
 * Clone of Custom Fields for Products.
 * Old Set up used the exact same classes and made it so that Proucts and Lots had to share
 * In this new set up we cannot have that and so Lots get their own custom fields
 *
 * @version 03/08/23
 * @author Jack Donaldson <jack.donaldson@mtc.co.uk>
 */

namespace Mtc\Auction;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

/**
 * Custom Field Eloquent model.
 * Implements Shop Custom Field management
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomField extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'auction_custom_fields';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'type',
        'custom_field_list_id',
        'database_field',
        'quantity',
        'multiple'
    ];

    /**
     * @var array Defined custom field types
     */
    public static $field_types = [
        'text' => 'Text Box',
        'textarea' => 'Text Area',
        'checkbox' => 'Checkbox',
        'date' => 'Date',
        'datetime' => 'Date & Time',
        'dropdown' => 'Dropdown',
        'map_coords' => 'Map Coordinates',
        'image_upload' => 'Image Upload'
    ];

    public static $custom_field_tables = [
        'auction_lot_custom'
    ];

    /**
     * Define relationship with fields assigned to a set
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function setFields()
    {
        return $this->hasMany(CustomFieldSetField::class, 'custom_field_id');
    }

    public function addColumn(string $field_name, string $field_type): void
    {
        foreach (self::$custom_field_tables as $table) {
            if (DB::getSchemaBuilder()->hasColumn($table, $field_name) === true) {
                // already exists
                continue;
            }

            DB::getSchemaBuilder()->table($table, function ($table) use ($field_name, $field_type) {
                if ($field_type === 'textarea') {
                    $table->text($field_name)->nullable();
                } else {
                    $table->string($field_name)->nullable();
                    $table->index($field_name);
                }
            });
        }
    }

    public function renameColumn(string $from, string $to): void
    {
        foreach (self::$custom_field_tables as $table) {
            DB::getSchemaBuilder()->table($table, function ($table) use ($from, $to) {
                $table->renameColumn($from, $to);
            });
        }
    }
}
