<?php

namespace Mtc\Auction\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\Auction\Auction;
use Mtc\Auction\Lot;
use Mtc\Auction\Lot\ProcessQueue;
use Mtc\Auction\Log\Log;

class EveryMinute extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'auction:minutely';



    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'The Minutely Cron for the auction platform. Handles the start and end of both Auctions and Lots';



    /**
     * Create a new command instance.
     *
     * @return void
     */

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */

    public function handle()
    {
        //Log::info("Minutely Cron is working fine!");
        if (!defined('DEV_MODE')) {
            define('DEV_MODE', config('app.env') !== 'production');
        }
        if (!defined('ENVIRONMENT')) {
            define('ENVIRONMENT', config('app.env'));
        }
        if (!defined('SITE_NAME')) {
            define('SITE_NAME', config('app.name'));
        }
        if (!defined('SITE_URL')) {
            define('SITE_URL', config('app.url'));
        }
        if (!defined('START_TIME')) {
            define('HTTPS_SITE_URL', config('app.url') ?? env('MAIL_FROM_NAME'));
        }
        if(!defined('START_TIME')) {
            define('START_TIME', microtime(true));
        }
        if(!defined('SITE_PATH')) {
            define('SITE_PATH', dirname(dirname(__DIR__)));
        }
        if(!defined('VAT_RATE')) {
            define('VAT_RATE', config('VAT_RATE') ?? 20);
        }
        if(!defined('FROM_EMAIL')) {
            define('FROM_EMAIL', config('FROM_EMAIL')??env('MAIL_FROM_ADDRESS'));
        }
        if(!defined('DEV_EMAIL')) {
            define('DEV_EMAIL', config('DEV_EMAIL') ?? 'dev.jd2@mtc.co.uk');
        }
        
        self::runProcessQueue();
        self::auctionStart();
        self::auctionEnd();
        self::auctionEndingSoon();

    }

    /**
     * Run cron for auction start
     */
    public static function auctionStart()
    {
        /** @var Auction $auction */
        $auction = Auction::auctionDueToStart();
        if ($auction && $auction->shouldStart()) {
            $auction->startAuction();
            /* TODO - Site Menu Changes */
        }
    }

    /**
     * Run cron for auction start
     */
    public static function auctionEnd()
    {
        Lot::endOverDueLots();

        //If crons fail to run some auctions could be left marked as live and this function used to only find the first live auction
        $auctions = Auction::query()
                           ->where('is_live', 1)
                           ->get();

        foreach ($auctions as $auction) {
            if ($auction) {
                if ($auction->shouldEndAuction()) {
                    $auction->endAuction();
                } else {
                    $auction->makeSureAuctionTimerHasNotEnded();
                }
            }
        }
    }

    /**
     * Run items from process queue
     */
    public static function runProcessQueue()
    {
        // Don't send out until all lots have and have been updated
        if (!Lot::canSendProcessingEmails()) {
            return;
        }

        ProcessQueue::processBuyer();

        // Only run if this has not taken over 50 seconds - email throttling
        if (microtime(true) - START_TIME < 50) {
            ProcessQueue::processSeller();
        }

        // Only run if this has not taken over 50 seconds - email throttling
        /*if (WATCHLIST_ENABLED === true && microtime(true) - START_TIME < 50) {
            ProcessQueue::processWatchlist();
        }*/
    }

    /**
     * Run cron for auction start
     */
    public static function auctionEndingSoon()
    {
        $auction = Auction::currentLiveAuction();
        /*if ($auction && $auction->endsSoon() && WATCHLIST_ENABLED == true) {
            Watchlist::triggerEndingSoonNotifications($auction);
        }*/
    }
}