<?php

namespace Mtc\Auction\Bid;

use Illuminate\Notifications\Notification;
use Mtc\Auction\Lot;

trait BidNotifications
{
    protected function tryNotifySuccessfulBid()
    {
        $subject = config('app.name') . " - Bid Received";
        $template = 'Auction/emails/bid_accepted_notification.twig';
        $this->tryNotifyOwner();
        return $this->sendNotification($subject, $template, 'bid_notification');
    }

    /**
     * Notify user about being outbid
     *
     * @return bool
     */
    protected function tryNotifyOutbid()
    {
        $lot = Lot::query()->find($this->lot_id);
        $params = [
            'member_id' => $this->member_id,
            'url' => $lot->getUrlAttribute(),
            'message' => "You have been out-bid on Lot #" . $lot->lot_id . ": " . $lot->name,
        ];
        //Notification::add($params);

        $subject = config('app.name') . " - You've Been Outbid";
        $template = 'Auction/emails/outbid.twig';
        return $this->sendNotification($subject, $template, 'outbid_notification');
    }

    /**
     * Send Bid Notification
     *
     * @param $subject
     * @param $template
     * @return bool
     */
    protected function sendNotification($subject, $template, $notification_type)
    {
        return false;
        
        if (!MemberNotification::shouldNotify($this->member_id, $notification_type)) {
            return false;
        }
        $lot = Lot::query()->find($this->lot_id);

        $twig = App::make('twig');
        $member = Member::query()->find($this->member_id);
        $content = $twig->render($template, [
            'top_bid' => $this,
            'lot' => $lot,
            'member' => $member,
        ]);

        email($member->email, $subject, $content);
        return true;
    }
}