<?php

namespace Mtc\Auction;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Mtc\Basket\Contracts\Purchasable;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Money\Price;

class AuctionMembershipFee extends Model implements Purchasable
{

    /**
     * Table name
     *
     * @var string $table
     */
    protected $table = 'auction_membership_fees';
    
    protected $fillable = [
        'name',
        'sku',
        'amount',
        'type',
    ];

    /**
     * Fields that are cast to prices
     *
     * @var array
     */
    protected $price_fields = [
        'amount',
    ];


    public function requiresShipping()
    {
        return false;
    }

    public function isAvailable(): bool
    {
        // TODO: Implement isAvailable() method.
        $member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;

        if(!is_null($member)) {
            $auction_member = AuctionMember::mutateMemberObject($member);
            if (!$auction_member->auction_fields->membership_fee_paid){
                return true;
            }
        }
        return false;
    }

    public function getWeight()
    {
        return 0;
    }

    public function getUrl()
    {
        //Should not be accessed Directly
    }

    public function getBasketImage()
    {
        // TODO: Implement getBasketImage() method.
    }

    public function getOriginalPrice()
    {
        $price_value = $this->amount;

        $price = new Price($price_value, $this->taxAttribute());
        $price->calculate();

        return $price;
    }

    public function hasDiscountedPrice()
    {
        // TODO: Implement hasDiscountedPrice() method.
    }

    public function getPrice()
    {

        $price_value = $this->amount;

        $price = new Price($price_value, $this->taxAttribute());
        $price->calculate();

        return $price;
    }

    public function taxAttribute()
    {

        return 0;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getSku()
    {
        return $this->sku;
    }

    public function getStock()
    {
        return 999; //Basically stock is infinite
    }

    public function getMaxQuantity()
    {
        return 1; //You can only have one membership fee in the basket at a time
    }

    public function getAttributeFields(): array
    {
        // TODO: Implement getAttributeFields() method.
        return [];
    }

    public function scopeSearchByTerm(Builder $query, string $term)
    {
        // TODO: Implement scopeSearchByTerm() method.
    }

    public function getSearchNameAttribute(): string
    {
        // TODO: Implement getSearchNameAttribute() method.
    }
}