<?php

namespace Mtc\Auction;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class AuctionMemberFields extends Model
{
    
    protected $table = 'auction_member_fields';
    
    /**
     * Mass assignable attributes
     *
     * @var array $fillable
     */
    protected $fillable = [
        'member_id',
        'unique_id',
        'buyer_membership_fee_paid',
        'seller_membership_fee_paid',
        'seller_information',
    ];
    
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        
    }

    public function generateUniqueID(){
        if (empty($member->unique_id)) {
            $retries_left = 1000;

            do {
                $this->unique_id = mt_rand(100000, 999999) . substr(str_shuffle(str_repeat($x = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil(2 / strlen($x)))),1,2);
            } while (AuctionMemberFields::where('unique_id', $this->unique_id)->where('member_id', '!=', $this->id)->exists() && $retries_left-- > 0);
        }
    }
}