<?php

namespace Mtc\Auction;

use Illuminate\Support\Facades\File;
use Mtc\Auction\Providers\AuctionServiceProvider;
use Mtc\Auction\Seeds\AuctionSeeder;
use Mtc\Foundation\Contracts\InstallableComponent;

class AuctionInstaller implements InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => AuctionServiceProvider::class,
                '--tag' => 'assets'
            ]
        ];
    }
    
    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     */
    public function seed(): string
    {
        return AuctionSeeder::class;
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        return [];
    }


    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }
}