<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingAuctionKeys extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //
        Schema::table('auction_lots', function (Blueprint $table) {
            $table->index('auction_id');
            $table->index('seller_id');
            $table->index('buyer_id');
            $table->index('brand_id');
            $table->index('register_order_id');
            $table->index('buy_order_id');
            $table->index('price_trends_id');
            $table->index('highest_bid');
            $table->index('published');
            $table->index('ends_at');
            
            //$table->fullText('name');
            //$table->fullText('description');
        });
        
        Schema::table('auctions', function (Blueprint $table) {
            $table->index('is_live');
        });
        
        Schema::table('auction_bids', function (Blueprint $table) {
            $table->index('lot_id');
            $table->index('member_id');
        });
        
        Schema::table('auction_lot_complementary_priority', function (Blueprint $table) {
            $table->index('field_id');
        });
        
        Schema::table('auction_lot_custom', function (Blueprint $table) {
            $table->index('lot_id');
        });
        
        Schema::table('auction_lot_images', function (Blueprint $table) {
            $table->index('lot_id');
            $table->index('default');
            $table->index('hover');
            $table->index('zoom');
        });
        Schema::table('auction_lot_insurance_fees', function (Blueprint $table) {
            $table->index('lot_id');
        });
        
        Schema::table('auction_lot_late_fees', function (Blueprint $table) {
            $table->index('lot_id');
        });
        
        Schema::table('auction_lot_payouts', function (Blueprint $table) {
            $table->index('lot_id');
        });
        
        Schema::table('auction_lot_pickup_methods', function (Blueprint $table) {
            $table->index('has_date_picker');
            $table->index('has_collection_points');
            $table->index('reminder');
        });
        
        Schema::table('auction_lot_post_live_process_queue', function (Blueprint $table) {
            $table->index('lot_id');
            $table->index('member_id');
            $table->index('action');
        });
        
        Schema::table('auction_lot_price_trends', function (Blueprint $table) {
            $table->index('catalogued_lot_name');
            //$table->fullText('catalogued_lot_name');
        });
        
        Schema::table('auction_lot_price_trend_entries', function (Blueprint $table) {
            $table->index('price_trend_id');
            $table->index('source');
            $table->index('auction_date');
            $table->index('amount');
        });
        
        Schema::table('auction_lot_seller_deliveries', function (Blueprint $table) {
            $table->index('lot_id');
            $table->index('delivery_method_id');
            $table->index('collection_point_id');
        });
        
        Schema::table('auction_membership_fees', function (Blueprint $table) {
            $table->index('sku');
        });
        
        Schema::table('auction_storage_lots', function (Blueprint $table) {
            $table->index('auction_id');
            $table->index('lot_id');
            $table->index('member_id');
            $table->index('location_id');
            $table->index('storage_expires_at');
        });
        
        Schema::table('auction_watchlist_lots', function (Blueprint $table) {
            $table->index('lot_id');
            $table->index('member_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
        Schema::table('auction_lots', function (Blueprint $table) {
            $table->dropIndex('auction_id');
            $table->dropIndex('seller_id');
            $table->dropIndex('buyer_id');
            $table->dropIndex('brand_id');
            $table->dropIndex('register_order_id');
            $table->dropIndex('buy_order_id');
            $table->dropIndex('price_trends_id');
            $table->dropIndex('highest_bid');
            $table->dropIndex('published');
            $table->dropIndex('ends_at');

            //$table->dropFullText('name');
            //$table->dropFullText('description');
        });

        Schema::table('auctions', function (Blueprint $table) {
            $table->dropIndex('is_live');
        });

        Schema::table('auction_bids', function (Blueprint $table) {
            $table->dropIndex('lot_id');
            $table->dropIndex('member_id');
        });

        Schema::table('auction_lot_complementary_priority', function (Blueprint $table) {
            $table->dropIndex('field_id');
        });

        Schema::table('auction_lot_custom', function (Blueprint $table) {
            $table->dropIndex('lot_id');
        });

        Schema::table('auction_lot_images', function (Blueprint $table) {
            $table->dropIndex('lot_id');
            $table->dropIndex('default');
            $table->dropIndex('hover');
            $table->dropIndex('zoom');
        });
        Schema::table('auction_lot_insurance_fees', function (Blueprint $table) {
            $table->dropIndex('lot_id');
        });

        Schema::table('auction_lot_late_fees', function (Blueprint $table) {
            $table->dropIndex('lot_id');
        });

        Schema::table('auction_lot_payouts', function (Blueprint $table) {
            $table->dropIndex('lot_id');
        });

        Schema::table('auction_lot_pickup_methods', function (Blueprint $table) {
            $table->dropIndex('has_date_picker');
            $table->dropIndex('has_collection_points');
            $table->dropIndex('reminder');
        });

        Schema::table('auction_lot_post_live_process_queue', function (Blueprint $table) {
            $table->dropIndex('lot_id');
            $table->dropIndex('member_id');
            $table->dropIndex('action');
        });

        Schema::table('auction_lot_price_trends', function (Blueprint $table) {
            $table->dropIndex('catalogued_lot_name');
            //$table->dropFullText('catalogued_lot_name');
        });

        Schema::table('auction_lot_price_trend_entries', function (Blueprint $table) {
            $table->dropIndex('price_trend_id');
            $table->dropIndex('source');
            $table->dropIndex('auction_date');
            $table->dropIndex('amount');
        });

        Schema::table('auction_lot_seller_deliveries', function (Blueprint $table) {
            $table->dropIndex('lot_id');
            $table->dropIndex('delivery_method_id');
            $table->dropIndex('collection_point_id');
        });

        Schema::table('auction_membership_fees', function (Blueprint $table) {
            $table->dropIndex('sku');
        });

        Schema::table('auction_storage_lots', function (Blueprint $table) {
            $table->dropIndex('auction_id');
            $table->dropIndex('lot_id');
            $table->dropIndex('member_id');
            $table->dropIndex('location_id');
            $table->dropIndex('storage_expires_at');
        });

        Schema::table('auction_watchlist_lots', function (Blueprint $table) {
            $table->dropIndex('lot_id');
            $table->dropIndex('member_id');
        });
    }
}
