<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDisplayFieldsToAuctionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('auctions', function (Blueprint $table) {
            //
            $table->text('banner_image')
                  ->nullable()->after('image');
            $table->longText('subtitle')
                  ->nullable()->after('content');
            $table->text('title')
                  ->nullable()->after('content');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('auctions', function (Blueprint $table) {
            //

            $table->dropColumn('banner_image');
            $table->dropColumn('subtitle');
            $table->dropColumn('title');
        });
    }
}
