<?php

namespace Mtc\ApiCallLogger\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\ApiCallLogger\Console\Commands\DeleteLogsCommand;

class ApiCallLoggerProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/api_call_logger.php', 'api_call_logger');
    }

    public function boot()
    {
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        $this->commandsAndSchedule();
    }

    public function commandsAndSchedule()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                DeleteLogsCommand::class
            ]);
        }
    }
}
