<?php

namespace Mtc\ApiCallLogger;

/**
 * a class to handle requests to log API calls and responses
 *
 * Class ApiCallLogger
 * @package Mtc\ApiCallLogger\Providers
 */
class ApiCallLogger
{
    /**
     * create a log entry
     *
     * @param string $api_name
     * @param string $url
     * @param string $request
     * @param null $response_code
     * @param string $response
     */
    public static function logCall($api_name = '', $url = '', $request = '', $response_code = null, $response = '')
    {
        if (!is_numeric($response_code)) {
            $response_code = null;
        }

        ApiCallLog::create([
            'api_name' => $api_name,
            'url' => $url,
            'request' => $request,
            'response_code' => $response_code,
            'response' => $response
        ]);
    }
}
