<?php

use App\Http\Middleware\AdminUserMiddleware;
use App\Http\Middleware\Authenticate;
use Illuminate\Support\Facades\Route;
use Mtc\AdminGoogle2fa\Http\Controllers\Google2faController;

Route::prefix('admin/google2fa')->middleware(Authenticate::class, AdminUserMiddleware::class)->group(function() {
    // verify google2fa on login
    Route::get('/verify', [Google2faController::class, 'show2faVerify'])->name("admin.g2fa.show.verify");
    Route::post('/verify', [Google2faController::class, 'process2faVerification'])->name("admin.g2fa.verify");

    Route::post('/manage/enable', [Google2faController::class, 'enable2fa'])->name("admin.g2fa.enable");
    // generate google2fa secret

    Route::post('/generate-secret', [Google2faController::class, 'generate2faSecret'])->name("admin.g2fa.generate-secret");

    // set up google2fa
    Route::get('/', [Google2faController::class, 'show2faSettings'])->name("admin.g2fa.settings");
});

Route::prefix('admin/google2fa')->middleware('auth')->group(function() {
    // manage google2fa user settings - mtc only
    Route::post('/manage/disable', [Google2faController::class, 'disable2fa'])->name("admin.g2fa.disable");

    Route::get('/manage', [Google2faController::class, 'show2faManage'])->name("admin.g2fa.manage");
});
