<?php

namespace Mtc\AdminGoogle2fa\Support;

use PragmaRX\Google2FALaravel\Support\Authenticator;

class Google2FAAuthenticator extends Authenticator
{
    /*
     * Check if request can pass without checking OTP
     */
    protected function canPassWithoutCheckingOTP(): bool
    {
        if ($this->getUser()->g2fa_enabled == 0) {
            return true;
        }

        return $this->noUserIsAuthenticated() || $this->twoFactorAuthStillValid();
    }

    /*
     * Get g2fa secret key
     */
    protected function getGoogle2FASecretKey()
    {
        $secret = $this->getUser()->g2fa_secret;

        if (is_null($secret) || empty($secret)) {
            throw new InvalidSecretKey('Secret key cannot be empty.');
        }

        return $secret;
    }

    /*
     * Check if user is authenticated with G2FA
     */
    public function isAuthenticated(): bool
    {
        return ($this->canPassWithoutCheckingOTP() || session("g2fa_verified"));
    }
}
